/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.salju.kobolds.init.KoboldsStructures;

public class AbstractKoboldStructure
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final Codec<AbstractKoboldStructure> CODEC = RecordCodecBuilder.mapCodec(codex -> codex.group((App)AbstractKoboldStructure.m_226567_((RecordCodecBuilder.Instance)codex), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(temppool -> temppool.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(name -> name.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(intys -> intys.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(heighty -> heighty.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(hacker -> hacker.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(mapster -> mapster.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(maxster -> maxster.maxDistanceFromCenter)).apply((Applicative)codex, AbstractKoboldStructure::new)).flatXmap(AbstractKoboldStructure.verifyRange(), AbstractKoboldStructure.verifyRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static Function<AbstractKoboldStructure, DataResult<AbstractKoboldStructure>> verifyRange() {
        return verify -> {
            int i = switch (verify.m_226620_()) {
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
                default -> throw new IncompatibleClassChangeError();
            };
            return verify.maxDistanceFromCenter + i > 128 ? DataResult.error((String)"Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)verify);
        };
    }

    public AbstractKoboldStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> pool, Optional<ResourceLocation> name, int inty, HeightProvider height, boolean hack, Optional<Heightmap.Types> map, int center) {
        super(config);
        this.startPool = pool;
        this.startJigsawName = name;
        this.maxDepth = inty;
        this.startHeight = height;
        this.useExpansionHack = hack;
        this.projectStartToHeightmap = map;
        this.maxDistanceFromCenter = center;
    }

    public AbstractKoboldStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> pool, int inty, HeightProvider height, boolean hack, Heightmap.Types map) {
        this(config, pool, Optional.empty(), inty, height, hack, Optional.of(map), 80);
    }

    public AbstractKoboldStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> pool, int inty, HeightProvider height, boolean hack) {
        this(config, pool, Optional.empty(), inty, height, hack, Optional.empty(), 80);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunk = context.f_226628_();
        int inty = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos pos = new BlockPos(chunk.m_45604_(), inty, chunk.m_45605_());
        if (!this.biomeCheck(context, pos)) {
            return Optional.empty();
        }
        Pools.m_236490_();
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)pos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)KoboldsStructures.KOBOLD_STRUCTURE.get();
    }

    protected boolean biomeCheck(Structure.GenerationContext context, BlockPos pos) {
        ChunkPos chunk = context.f_226628_();
        if (!(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int range = 3;
            int y = pos.m_123342_();
            if (this.projectStartToHeightmap.isPresent()) {
                y += context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
            }
            y = QuartPos.m_175400_((int)y);
            for (int x = chunk.f_45578_ - range; x <= chunk.f_45578_ + range; ++x) {
                for (int z = chunk.f_45579_ - range; z <= chunk.f_45579_ + range; ++z) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)x), y, QuartPos.m_175404_((int)z), context.f_226624_().m_224579_());
                    if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("minecraft:is_ocean"))) && !biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("minecraft:is_river")))) continue;
                    return false;
                }
            }
        }
        BlockPos center = chunk.m_151394_(0);
        int height = context.f_226622_().m_223235_(center.m_123341_(), center.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn noise = context.f_226622_().m_214184_(center.m_123341_(), center.m_123343_(), context.f_226629_(), context.f_226624_());
        BlockState state = noise.m_183556_(center.m_123342_() + height);
        return state.m_60819_().m_76178_();
    }
}

